PLAY_ANY_LEVEL	= 1		;0 = can't play last level until other levels have been completed
					;1 = you can play the last level any time

	.include	'eq.s'
	.include	'externs.s'

	.text
selloop::
	bsr		curs_loc				;get current location of cursor
	bsr		blitdash				;draw stuff in dashboard
	bsr		plnt_txt				;draw text describing currently selected level
	bsr		sel_info				;draw lives, special weapon, score
	bsr		do_colors				;color cycling

	move.l	#selobjs,FIRSTOBJ_ADR	;address of first object header
	move.l	#SEL_OBJS,TOTOBJS_ADR	;total objects in list
	bsr		do_build				;build packed object list

	bsr		input
	bsr		selinput
	rts

sel_info::
	bsr		draw_lives
	bsr		draw_icns
	bsr		draw_score
	rts

selinput::
	bsr		sel_joy
	bsr		sel_but
	bsr		input_keys			;allow keypad to change special weapon
	rts

sel_joy::
	move.l	joycur,d0
	btst.l	#JOY_UP,d0			;d0 is joypad status, could be edge or cur
	beq.b	.20					;check down if not moving up
	bsr		curs_up
	bra.b	.30
.20:	btst.l	#JOY_DOWN,d0			;d0 is joypad status, could be edge or cur
	beq.b	.30					;check left and right next
	bsr		curs_dn
.30:	btst.l	#JOY_LEFT,d0			;d0 is joypad status, could be edge or cur
	beq.b	.40					;check right if not moving left
	bsr		curs_lf
	rts							;don't need to check right if moving left
.40:	btst.l	#JOY_RIGHT,d0			;d0 is joypad status, could be edge or cur
	beq.b	.90
	bsr		curs_rt
.90:	rts

curs_up::
	sub.w	#6,cursor+O_YPOS
	cmp.w	#SCRN_TOP,cursor+O_YPOS
	bge		.50
	move.w	#SCRN_TOP,cursor+O_YPOS
.50:	rts

curs_dn::
	add.w	#6,cursor+O_YPOS
	cmp.w	#SCRN_BOTTOM-20,cursor+O_YPOS
	blt.b	.50
	move.w	#SCRN_BOTTOM-20,cursor+O_YPOS
.50:	rts

curs_lf::
	sub.w	#4,cursor+O_XPOS
	tst.w	cursor+O_XPOS
	bpl.b	.50					;off left side if negative
	move.w	#0,cursor+O_XPOS
.50:	rts

curs_rt::
	add.w	#4,cursor+O_XPOS
	cmp.w	#SCRN_RIGHT-8,cursor+O_XPOS
	blt.b	.50
	move.w	#SCRN_RIGHT-8,cursor+O_XPOS
.50:	rts

sel_but::
	move.l	joyedge,d0
	and.l	#ANY_FIRE,d0			;check for any fire button
	beq.b	.90
	move.b	selection,d0
	cmp.b	#$FF,d0
	beq.b	.90					;no planet selected
	cmp.b	#TOTAL_WORLDS-1,d0		;last planet
	bne.b	.40
	move.w	#TOTAL_WORLDS-2,d1		;all other planets - 1
	lea		finished,a0
.20:	tst.b	(a0)+

.if PLAY_ANY_LEVEL = 0
	beq.b	.90					;if any other levels have not been completed, don't start last level
.endif

	dbra		d1,.20

.40:	and.w	#$FF,d0				;make sure high byte is clear
	lsl.w	#1,d0				;selection * 2
	move.w	d0,level


;******************************************************
	move.l	#FIRE_B,firebut		;make B button fire bullets
	move.l	#FIRE_A,bombbut		;make A button drop bombs
	move.l	#FIRE_C,specbut		;make C button fire special weapon
;******************************************************

	move.b	#GAME_MODE,gamemode
	bsr		go_intro
.90:	rts

curs_loc::						;see if the cursor is over a planet
	clr.w	d6					;count planets
	lea		planet1,a1			;first planet object
	move.w	cursor+O_XPOS,d0		;get cursor xpos
	add.w	#8,d0				;add cursor width
	move.w	cursor+O_XPOS,d1
	move.w	cursor+O_YPOS,d2		;get cursor ypos
	add.w	#20,d2				;add cursor height in half lines
	move.w	cursor+O_YPOS,d3
.10:
	move.w	O_XPOS(a1),d4			;get planet xpos
	cmp.w	d0,d4				;compare cursor xpos + width (d0) to planet xpos (d4)
	bge.b	.50					;if planet xpos > cursor xpos + width, exit

	cmp.w	#TOTAL_WORLDS-1,d6		;see if this is the big planet
	bne.b	.20
	add.w	#16,d4				;add extra width for big planet
.20:	add.w	#40,d4				;add width of planet to its xpos
	cmp.w	d1,d4				;compare cursor xpos (d1) to planet xpos + width (d4)
	blt.b	.50					;if planet xpos + width < cursor xpos, exit

	move.w	O_YPOS(a1),d4			;get planet ypos
	cmp.w	d2,d4				;compare cursor ypos + height to planet ypos
	bge.b	.50					;if planet ypos >= cursor + height, exit

	cmp.w	#TOTAL_WORLDS-1,d6		;see if this is the big planet
	bne.b	.30
	add.w	#28,d4				;add extra height for big planet
.30:	add.w	#64,d4				;add 2*height of planet to its ypos (half lines)
	cmp.w	d3,d4				;compare cursor ypos (d3) to planet ypos + height (d4)
	blt.b	.50					;if planet ypos + height < cursor ypos, exit

	cmp.b	selection,d6
	beq.b	.90					;selection did not change
	move.b	d6,selection			;cursor is over a planet
	rts
.50:
	adda.l	#OBJ_SIZE,a1			;next object header
	addq.w	#1,d6				;planet counter
	cmp.w	#TOTAL_WORLDS+1,d6		;total planets + bonus level
	bne.b	.10
	move.b	#$FF,selection			;cursor is not over a planet
.90:	rts

plnt_txt::
	clr.w	d0
	move.b	selection,d0
	cmp.b	#$FF,d0
	beq.b	.90					;cursor not over a planet if $FF
	lsl.w	#2,d0
	lea		strtable,a1
	move.l	(a1,d0.w),a0			;address of string
	move.l	#$00060050,d5			;Y,X position of first char
	move.l	#$00000050,d6			;left margin
	move.l	#$00090000,d4			;line feed spacing in high word
	bsr		blitstr
	clr.w	d0
	move.b	selection,d0

.50:	lea		finished,a1			;status of each level
	tst.b	(a1,d0.w)				;0 if level has not been completed
	beq.b	.90
	lea		strcomp,a0
.80:	move.l	#$00210050,d5			;Y,X position of first char
	move.l	#$00090000,d4			;line feed spacing in high word
	bsr		blitstr
.90:	rts

blitstr::
;d4 = pixels to move down for a line feed
;d5 = X,Y position of first char
;d6 = left margin in high word, low word is 0
	move.l	#PITCH1|PIXEL8|WID448|XADDPIX,A1_FLAGS	;description of destination area
	move.l	#dash,A1_BASE						;destination address
	move.l	#PITCH1|PIXEL8|XADDPIX,A2_FLAGS		;description of source data
	move.l	#$0001FFFA,A1_STEP					;1 in Y step size, negative width in X step size
.10:	clr.l	d0
	move.b	(a0)+,d0				;get the character
	cmp.b	#0,d0				;0 is end of string data
	beq.b	.90
	cmp.b	#' ',d0				;blank space
	beq.b	.50
	cmp.b	#'_',d0				;half space
	beq.b	.60
	cmp.b	#']',d0				;return
	bne.b	.20
	add.l	d4,d5				;move down 1 line
	and.l	#$FFFF0000,d5			;leave Y unchanged, set X position to 0
	or.l		d6,d5				;set X to left margin
	bra.b	.10					;do next character
.20:	lea		fontaddr,a5
	sub.b	#'!',d0				;the first valid character
	lsl.w	#2,d0				;4 bytes per character address
	move.l	(a5,d0.w),d7			;address of current character data
	bsr		blit_chr
.50:	add.l	#$00000004,d5			;add part of the width of a character
.60:	add.l	#$00000002,d5			;add part of the width of a character
	bra.b	.10
.90:	rts

blit_chr::
;d5 is the top left corner X,Y
;d7 is the address of the image data
	move.l	d7,A2_BASE					;source address
	move.l	#0,A2_PIXEL					;start at 0,0 of source image
	move.l	d5,A1_PIXEL					;Y,X position to write data in destination area
	move.l	#$00070006,B_COUNT				;height, width of source image
	move.l	#UPDA1|SRCEN|LFU_A|LFU_AN,B_CMD	;turn on blitter
	rts

blitdash::
	move.l	#PITCH1|PIXEL32|WID112|XADDPHR,A1_FLAGS
	move.l	#dash,A1_BASE					;destination address
	move.l	#0,A1_PIXEL					;get rectangle Y,X
	move.l	#$0001FF90,A1_STEP				;high = Y step, low = negative width
	move.l	#$00340070,B_COUNT				;high = height, low = width
	move.l	#0,B_PATD						;write 0's to clear the window
	move.l	#0,B_PATD+4
	move.l	#PATDSEL|UPDA1,B_CMD
	rts

goselect::
;blit all of the object data for the select screen
;   160		;  8 x  10 cursor
	jsr		clearscr

	bsr		ld_decmp				;load decompression GPU code

	clr.b	levstatus
	move.b	#SELECT_MODE,gamemode
	bsr		conv_score			;update score numbers

	move.l	#PITCH1|PIXEL32|WID80|XADDPHR,d0
	move.l	d0,A1_FLAGS			;destination
	move.l	d0,A2_FLAGS			;source
	move.l	#cursdta,A1_BASE		;destination address
	move.l	#cursrom,A2_BASE		;source address
	move.l	#0,A2_PIXEL			;start at 0,0 of source image
	move.l	#0,A1_PIXEL			;Y,X position to write data in destination area
	move.l	#$00010050,B_COUNT		;1 x 80 (32 bit)
	move.l	#$0001FFB0,A1_STEP		;1 in Y step size, negative width in X step size
	move.l	#$0001FFB0,A2_STEP		;1 in Y step size, negative width in X step size
	move.l	#UPDA1|UPDA2|SRCEN|LFU_A|LFU_AN,B_CMD
	bsr		erase_info
	bsr		ld_selbk				;load background
	bsr		ld_plnts
	bsr		ld_build				;load object list builder GPU code
	rts

ld_selbk::
	move.l	#q85,a3				;starting address of default dq_table
	bsr		load_dq

	move.l	#56,Out_Width
	move.l	#WID448,Out_E_Width

	move.l	#s03,In_Adr			;address of compressed picture data
	move.l	#selback,Out_Adr		;where to put the decompressed data
	bsr		decomp

	move.l	#s04,In_Adr			;address of compressed picture data
	move.l	#selback+128,Out_Adr	;where to put the decompressed data
	bsr		decomp

	move.l	#s05,In_Adr			;address of compressed picture data
	move.l	#selback+256,Out_Adr	;where to put the decompressed data
	bsr		decomp

	move.l	#s06,In_Adr			;address of compressed picture data
	move.l	#selback+384,Out_Adr	;where to put the decompressed data
	bsr		decomp

	move.l	#s07,In_Adr			;address of compressed picture data
	move.l	#selback+512,Out_Adr	;where to put the decompressed data
	bsr		decomp

	move.l	#s08,In_Adr			;address of compressed picture data
	move.l	#selback+640,Out_Adr	;where to put the decompressed data
	bsr		decomp

	move.l	#s09,In_Adr			;address of compressed picture data
	move.l	#selback+768,Out_Adr	;where to put the decompressed data
	bsr		decomp

	rts

ld_plnts::
	move.l	#q65,a3				;starting address of default dq_table
	bsr		load_dq

	move.l	#8,Out_Width			;64 pixels
	move.l	#WID64,Out_E_Width
	move.l	#earth,In_Adr			;address of compressed picture data
	move.l	#bgplanet,Out_Adr		;where to put the decompressed data
	bsr		decomp

	move.l	#6,Out_Width			;48 pixels
	move.l	#WID48,Out_E_Width
	move.l	#desplan,In_Adr		;address of compressed picture data
	move.l	#plan00,Out_Adr		;where to put the decompressed data
	bsr		decomp

	move.l	#bgplanet,ADJBLACK_START			;destination address
	move.l	#bgplanet+(64*48*2),ADJBLACK_END	;end address
	bsr		adjblak
	move.l	#plan00,ADJBLACK_START			;destination address
	move.l	#plan00+(48*800*2),ADJBLACK_END	;total size
	bsr		adjblak

	bsr		ld_uncmp

	move.l	#bgplanet,A1_BASE		;destination address
	move.l	#PITCH1|PIXEL16|WID64|XADDPIX,A1_FLAGS	;destination window
	move.l	#PITCH1|PIXEL1|WID64|XADDPIX,A2_FLAGS	;destination window
	move.l	#$00300040,B_COUNT		;height, width of source data
	move.l	#$0001FFC0,A1_STEP		;1 in Y step size, negative width in X step size
	move.l	#$0001FFC0,A2_STEP		;1 in Y step size, negative width in X step size
	move.l	#earth_m,UNCOMP_START	;compressed data
	move.l	#screen+(64*48/8),UNCOMP_END	;end address
	bsr		blitmask

	move.l	#plan00,A1_BASE		;destination address
	move.l	#PITCH1|PIXEL16|WID48|XADDPIX,A1_FLAGS	;destination window
	move.l	#PITCH1|PIXEL1|WID40|XADDPIX,A2_FLAGS	;destination window
	move.l	#$03200028,B_COUNT		;height, width of source data
	move.l	#$0001FFD8,A1_STEP		;1 in Y step size, negative width in X step size
	move.l	#$0001FFD8,A2_STEP		;1 in Y step size, negative width in X step size
	move.l	#despln_m,UNCOMP_START	;compressed data
	move.l	#screen+(40*800/8),UNCOMP_END	;end address
	bsr		blitmask

	rts

fontaddr::
	dc.l		fnt_excl,fnt_quot,fnt_pnd,fnt_dol,fnt_perc,fnt_amp,fnt_apos,fnt_lpar,fnt_rpar
	dc.l		fnt_astr,fnt_plus,fnt_com,fnt_hyph,fnt_per,fnt_slsh
	dc.l		fnt_0,fnt_1,fnt_2,fnt_3,fnt_4,fnt_5,fnt_6,fnt_7,fnt_8,fnt_9
	dc.l		fnt_col,fnt_semi,fnt_less,fnt_equ,fnt_grtr,fnt_ques,fnt_at
	dc.l		fnt_a,fnt_b,fnt_c,fnt_d,fnt_e,fnt_f,fnt_g,fnt_h,fnt_i,fnt_j,fnt_k,fnt_l,fnt_m
	dc.l		fnt_n,fnt_o,fnt_p,fnt_q,fnt_r,fnt_s,fnt_t,fnt_u,fnt_v,fnt_w,fnt_x,fnt_y,fnt_z
string0::		dc.b		'OSSEOUS]'
			dc.b		'DESERT PLANET]'
			dc.b		0
string1::		dc.b		'GROTTONERIA]'
			dc.b		'CAVE PLANET]'
			dc.b		0
string2::		dc.b		'ZEPHYRIA]'
			dc.b		'AIR WORLD]'
			dc.b		0
string3::		dc.b		'EQUILIBRIUMITE]'
			dc.b		'YIN YANG PLANET]'
			dc.b		0
string4::		dc.b		'COSMOLITE]'
			dc.b		'THE CITY]',0
string5::		dc.b		'BONUS LEVEL]'
			dc.b		0
strcomp::		dc.b		'NO LIFE DETECTED',0

	.even
strtable::
	dc.l		string0,string1,string2,string3,string4,string5

selolst::
;selbackg::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		0			; o_xpos	
	dc.w		SCRN_TOP		; o_ypos
	dc.w		236			; o_height
	dc.w		112			; o_dwidth
	dc.w		112			; o_iwidth
	dc.l		selback		; o_data
	dc.b		0			; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;planet1::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		104			; o_xpos	
	dc.w		SCRN_TOP+64	; o_ypos
	dc.w		32			; o_height
	dc.w		12			; o_dwidth
	dc.w		10			; o_iwidth
	dc.l		plan00		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;planet2::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		78			; o_xpos	
	dc.w		SCRN_TOP+227	; o_ypos
	dc.w		32			; o_height
	dc.w		12			; o_dwidth
	dc.w		10			; o_iwidth
	dc.l		plan06		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;planet3::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		292			; o_xpos	
	dc.w		SCRN_TOP+60	; o_ypos
	dc.w		32			; o_height
	dc.w		12			; o_dwidth
	dc.w		10			; o_iwidth
	dc.l		plan12		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;planet4::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		334			; o_xpos	
	dc.w		SCRN_TOP+214	; o_ypos
	dc.w		32			; o_height
	dc.w		12			; o_dwidth
	dc.w		10			; o_iwidth
	dc.l		plan19		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;planet5::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		193			; o_xpos	
	dc.w		SCRN_TOP+158	; o_ypos
	dc.w		48			; o_height
	dc.w		16			; o_dwidth
	dc.w		16			; o_iwidth
	dc.l		bgplanet		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;planet6::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		200			; o_xpos	
	dc.w		SCRN_TOP+290	; o_ypos
	dc.w		32			; o_height
	dc.w		12			; o_dwidth
	dc.w		10			; o_iwidth
	dc.l		plan14		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;dashobj::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		3			; o_depth
	dc.w		0			; o_xpos	
	dc.w		DASHYPOS		; o_ypos
	dc.w		52			; o_height
	dc.w		56			; o_dwidth
	dc.w		56			; o_iwidth
	dc.l		dash			; o_data
	dc.b		0			; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;selicons::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		3			; o_depth
	dc.w		ICON_XPOS		;xpos	
	dc.w		ICON_YPOS		;ypos
	dc.w		15			; o_height
	dc.w		10			; o_dwidth
	dc.w		10			; o_iwidth
	dc.l		iconbar		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;selscore::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		3			; o_depth
	dc.w		SCORE_XPOS	;xpos	
	dc.w		SCORE_YPOS	;ypos
	dc.w		12			; o_height
	dc.w		10			; o_dwidth
	dc.w		10			; o_iwidth
	dc.l		scorebar		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;cursor::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		108			; o_xpos	
	dc.w		SCRN_TOP+64	; o_ypos
	dc.w		10			; o_height
	dc.w		2			; o_dwidth
	dc.w		2			; o_iwidth
	dc.l		cursdta		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------

